<?php
/**
 * Template Name: Products
 */

get_header(); ?>
<?php while ( have_posts() ) :
	the_post();
	$header_bg = get_field( 'header_bg' );
	?>
	<div class="container">
		<!--<div style="margin: 0 auto; padding: 0;"><center><a href="https://animalnecessity.com/promotions" title="10% Off SiteWide"><img src="https://animalnecessity.com/images/OFM-OG-Sept2023.jpg" alt="10% Off SiteWide" style="width: 100%; height: auto; max-width: 800px;"></a></center></div>-->
		<div class="sub-products-header clearfix">
			<?php
			//content and header
			$sub_header         = get_field( 'sub_header_headline' );
			$sub_header_content = get_field( 'sub_header_content' );
			?>
			<p class="left"><?php echo $sub_header; ?></p>

			<p><?php echo $sub_header_content; ?></p>

		</div>

	</div><!-- .container -->
	
	<div class="container brochure-wrap">
		<?php if( have_rows('products') ): ?>
		<div class="internal-product-rotator">
			<?php while( have_rows('products') ): the_row();
				// vars
				$image = get_sub_field('product_image');
				$title = get_sub_field('product_title');
				$desc = get_sub_field('product_description');
				$link = get_sub_field('product_link');
				?>
				<div class="internal-product-rotator-block">
				<div class="internal-product-rotator-pad">
					<div class="ipr-image">
						<a href="<?php echo $link; ?>" title="<?php echo $title; ?>"><img src="<?php echo $image; ?>" alt="<?php echo $title; ?>"></a>
					</div>
					<div class="ipr-text">
						<h2 class="ipr-title"><?php echo $title; ?></h2>
						<div class="ipr-desc"><?php echo $desc; ?></div>
						<div class="ipr-link"><a href="<?php echo $link; ?>" title="Learn More about <?php echo $title; ?>">Learn More And Buy &#8594;</a></div>
					</div><!--end ipr-text-->
				</div><!--end internal-rotator-pad-->
				</div><!--end internal-rotator-block-->
			<?php endwhile; ?>
		</div><!--end home-internal-rotator-->
		<?php endif; ?>
		<div class="clear"></div>
	</div>
	
	<?php // check if the repeater field has rows of data
	$counter = 0;
	if ( have_rows( 'reasons' ) ): ?>
		<div class="reasons section">
			<div class="container">

				<h2 class="reasons-heading"><?php echo get_field( 'reason_header' ); ?></h2>
				<ul class="reasons-list">
					<?php // loop through the rows of data
					while ( have_rows( 'reasons' ) ) : the_row();
						$counter ++; ?>
						<li>
							<span class="count"><?php echo $counter; ?></span>

							<div class="reason-content">
								<?php
								// display reason
								echo wpautop( get_sub_field( 'reason' ) ); ?>
							</div>
						</li>
					<?php endwhile; ?>
				</ul>
			</div>
		</div>
	<?php endif; //reasons
	?>

	<?php

	//Collect some vars
	$team_section_heading = get_field( 'team_heading' );
	$team_subheading      = get_field( 'team_subheading' );

	/**
	 * Query Team Posts
	 */
	$args = array(
		'post_type'      => 'team',
		'posts_per_page' => - 1
	);
	// The Query
	$the_query = new WP_Query( $args );

	// The Loop
	if ( $the_query->have_posts() ) : ?>

		<div class="team-wrap section">

			<div class="container">
				<h2 class="team-section-heading"><?php echo $team_section_heading; ?></h2>

				<div class="team-section-heading-content"><?php echo wpautop( $team_subheading ); ?></div>

				<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>

					<?php get_template_part( 'inc/layout-team' ); ?>

				<?php endwhile; ?>
			</div>
		</div>
	<?php endif; ?>

	<?php

	// Reset Post Data
	wp_reset_postdata(); ?>


<div class="product-facts section">
	<div class="container">

		<div class="fact-content">

			<h2 class="product-facts-header section-heading"><?php echo get_field( 'fact_heading' ); ?></h2>

			<?php echo get_field( 'fact_content' ); ?>

			</div>

	</div>
</div>

<?php endwhile; // end of the loop. ?>

<?php get_footer(); ?>
