<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package ocuglo
 */

get_header(); ?>
<?php while (have_posts()) :
the_post();
$alt_title = get_field( 'alternate_title' );
$sub_title = get_field( 'sub_title_text' );
?>
	<header class="entry-header">
		<div class="header-inner container">
			<div class="row">
				<?php
				if ( ! empty( $alt_title ) ) {
					echo '<h1 class="entry-title">' . $alt_title . '</h1>';
				} else {
					the_title( '<h1 class="entry-title">', '</h1>' );
				}

				if ( ! empty( $sub_title ) ) {
					echo '<p class="sub-title">' . $sub_title . '</p>';
				}
				?>
			</div>
		</div>
	</header><!-- .entry-header -->


<div class="container">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<?php get_template_part( 'content', 'page' ); ?>

		</main>
		<!-- #main -->
	</div>
	<!-- #primary -->
	<?php endwhile; // end of the loop. ?>
	<?php get_sidebar(); ?>
</div><!-- .container -->

<?php get_footer(); ?>
