<?php
/**
 * ocuglo functions and definitions
 *
 * @package ocuglo
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 600; /* pixels */
}

if ( ! function_exists( 'ocuglo_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function ocuglo_setup() {

		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on ocuglo, use a find and replace
		 * to change 'ocuglo' to the name of your theme in all the template files
		 */
		load_theme_textdomain( 'ocuglo', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
		 */
		//add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => __( 'Primary Menu', 'ocuglo' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'ocuglo_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );
	}
endif; // ocuglo_setup
add_action( 'after_setup_theme', 'ocuglo_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function ocuglo_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar', 'ocuglo' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
}

add_action( 'widgets_init', 'ocuglo_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function ocuglo_scripts() {
	wp_enqueue_style( 'ocuglo-fonts', 'http://fonts.googleapis.com/css?family=Lato:300,400,700,900,300italic,400italic,900italic' );
	wp_enqueue_style( 'ocuglo-superslides', get_template_directory_uri() . '/assets/css/superslides.css' );
	wp_enqueue_style( 'ocuglo-style-css', get_template_directory_uri() . '/assets/css/base.css' );
	wp_enqueue_style( 'ocuglo-style', get_stylesheet_uri() );
	wp_enqueue_script( 'ocuglo-js', get_template_directory_uri() . '/assets/js/main.js', array(), '20120406', true );
	wp_enqueue_script( 'ocuglo-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), '20120206', true );
	wp_enqueue_script( 'ocuglo-superslides', get_template_directory_uri() . '/assets/js/jquery.superslides.min.js', array(), '20120226', true );
	wp_enqueue_script( 'ocuglo-glide', get_template_directory_uri() . '/assets/js/jquery.glide.js', array(), '34523', false );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

add_action( 'wp_enqueue_scripts', 'ocuglo_scripts' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load Custom Widget
 */
require get_template_directory() . '/inc/widget-ocuglo-rotator.php';
