<?php
/**
 *  givewp.dev - featured-addons-widget.php
 *
 * @description: Adds a featured addons widgets
 * @copyright  : http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since      : 1.0.0
 * @created    : 4/2/2015
 */

/**
 * Adds Ocuglo_Rotator_Widget widget.
 */
class Ocuglo_Rotator_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'give_ocuglo_rotator_widget', // Base ID
			__( 'Ocu-GLO Rotator Widget', 'ocuglo_widget' ), // Name
			array( 'description' => __( 'A custom widget that displays Ocu-GLO products in a carousel rotator.', 'ocuglo_widget' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		extract( $args );

		if ( $before_widget ) {
			echo $before_widget;
		}
		?>

		<?php
		/**
		 *  Ocu-GLO Carousel
		 *
		 * @description: This carousel is used on various landing pages and rotates various Ocu-GLO products
		 * @since      :
		 * @created    : 11/13/2014
		 */
         if(is_page(14)) { ?> 
		 <div class="product-bottle">
			<div class="product-slider slider" style="margin-bottom:10px;">
				<ul class="slider__wrapper">
					<li class="slider__item">
						<div class="product-container">
							<div class="bottle">
<p class="top-title">
									<span class="above-bottle-text">Ocu-GLO Human Vision Formula&trade;</span>
								</p>
								<img class="ocu-glo-bottle" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/ocu-glo-human-bottle.png" />
								<br>
								<strong>Your Price: $<span class="price">80.00</span></strong>
							</div>
							<div class="add-to-cart">
								<a class="green-button" href="https://animalnecessity.com/ocuglo/ocu-glo-human-vision-formula/ocu-glo-human-vision-formula.html" target="_blank">View Product</a>

								<img src="//animalnecessity.com/pages/landing-pages/assets/img/lock.png">
							</div>
						</div>
					</li>
				</ul>

			</div>
			<!-- /.end slider -->
			<div class="social-proof">
				<img class="natural-products" src="//animalnecessity.com/pages/landing-pages/assets/img/natural-products.png">
				<img class="flag" src="//animalnecessity.com/pages/landing-pages/assets/img/flag.png">
			</div>

		</div>
		 <script>
			jQuery.noConflict();
			(function ( $ ) {
				$( function () {
					//Product Slider
					$( '.product-slider' ).glide( {
						autoplay  : false,
						arrows    : '.product-bottle',
						navigation: '.product-bottle'
					} );
				} );
			})( jQuery );
		</script>
		 
		<?php } else { ?> 
		<div class="product-bottle">
			<div class="product-slider slider">
				<ul class="slider__wrapper">
					<li class="slider__item">
						<div class="product-container">
							<div class="bottle">
								<p class="top-title">
									<span class="ocu-glo-replace">Ocu-GLO&trade;</span>
									<span class="blue-text above-bottle-text">for MEDIUM to LARGE Dogs</span>
								</p>
								<img class="ocu-glo-bottle" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/carousel-product-ocu-glo-lrg.png" />

								<br>
								<strong>Your Price: $<span class="price">75.00</span></strong>
							</div>
							<div class="add-to-cart">
								<a class="green-button" href="http://animalnecessity.com/all-natural-pet-care-supplement-products/ocu-glo-rx-natural-dog-eye-care/ocu-glo-rx-medium-to-large-dogs.html">View Product</a>
								<img src="//animalnecessity.com/pages/landing-pages/assets/img/lock.png">
							</div>
						</div>
					</li>
					<li class="slider__item">
						<div class="product-container">
							<div class="bottle">
								<p class="top-title">
									<span class="ocu-glo-replace">Ocu-GLO&trade;</span>
									<span class="blue-text above-bottle-text">for SMALL Dogs</span>
								</p>
								<img class="ocu-glo-bottle" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/carousel-product-ocu-glo-sml.png" />

								<br>
								<strong>Your Price: $<span class="price">70.00</span></strong>
							</div>
							<div class="add-to-cart">
								<a class="green-button" href="http://animalnecessity.com/all-natural-pet-care-supplement-products/ocu-glo-rx-natural-dog-eye-care/ocu-glo-rx-small-dogs.html">View Product</a>

								<img src="//animalnecessity.com/pages/landing-pages/assets/img/lock.png">
							</div>
						</div>
					</li>
					<li class="slider__item">
						<div class="product-container">
							<div class="bottle">
								<p class="top-title">
									<span class="ocu-glo-replace">Ocu-GLO&trade;</span>
									<span class="blue-text above-bottle-text">for Small Dog Snip Caps</span>
								</p>
								<img class="ocu-glo-bottle" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/carousel-product-ocu-glo-sml.png" />
								<br>
								<strong>Your Price: $<span class="price">80.00</span></strong>
							</div>
							<div class="add-to-cart">
								<a class="green-button" href="http://animalnecessity.com/all-natural-pet-care-supplement-products/ocu-glo-rx-natural-dog-eye-care/ocu-glo-rx-small-snip-caps.html">View Product</a>

								<img src="//animalnecessity.com/pages/landing-pages/assets/img/lock.png">
							</div>
						</div>
					</li>
				</ul>

			</div>
			<!-- /.end slider -->
			<div class="social-proof">
				<img class="natural-products" src="//animalnecessity.com/pages/landing-pages/assets/img/natural-products.png">
				<img class="flag" src="//animalnecessity.com/pages/landing-pages/assets/img/flag.png">
			</div>

		</div>
		<script>
			jQuery.noConflict();
			(function ( $ ) {
				$( function () {
					//Product Slider
					$( '.product-slider' ).glide( {
						autoplay  : 5000,
						arrows    : '.product-bottle',
						navigation: '.product-bottle'
					} );
				} );
			})( jQuery );
		</script>
		<?php } ?>

		<?php
		if ( $after_widget ) {
			echo $after_widget;
		}

	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 *
	 * @return void
	 */
	public function form( $instance ) {
		$ids = ! empty( $instance['ids'] ) ? $instance['ids'] : '';
		?>
		<p> There are no options for this widget. All options are contained within the code at /wp-content/themes/ocuglo/inc/widget-ocuglo-rotator.php</p>
	<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance        = array();
		$instance['ids'] = ( ! empty( $new_instance['ids'] ) ) ? strip_tags( $new_instance['ids'] ) : '';

		return $instance;
	}

} // class Ocuglo_Rotator_Widget

// register Foo_Widget widget
function give_register_ocuglo_rotator_widget() {
	register_widget( 'Ocuglo_Rotator_Widget' );
}

add_action( 'widgets_init', 'give_register_ocuglo_rotator_widget' );