<?php
/**
 *  Newsletter Signup form with Constant Contact
 *
 * @description: Uses CC SDK to submit to AN list
 * @created    : 10/14/2014
 */

//Load CC SDK
require_once get_template_directory() . '/inc/constant-contact-sdk/src/Ctct/autoload.php';
use Ctct\ConstantContact;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\Contacts\ContactList;
use Ctct\Components\Contacts\EmailAddress;
use Ctct\Exceptions\CtctException;

define( "APIKEY", "vj3wxkya25jsr9jsyygz62zs" );
define( "ACCESS_TOKEN", "dcab3e5b-f1e8-47f5-82f4-4bb5f01b6ccf" );

$cc = new ConstantContact( APIKEY );

// check if the form was submitted
if ( isset( $_POST['cc-email'] ) && strlen( $_POST['cc-email'] ) > 1 ) {
	$action = "Getting Contact By Email Address";
	try {
		// check to see if a contact with the cc-email addess already exists in the account
		$response = $cc->getContactByEmail( ACCESS_TOKEN, $_POST['cc-email'] );

		// create a new contact if one does not exist
		if ( empty( $response->results ) ) {
			$action = "Creating Contact";

			$contact = new Contact();
			$contact->addEmail( $_POST['cc-email'] );
			$contact->addList( $_POST['cc-list'] );
			$contact->first_name = $_POST['cc-name'];
			$returnContact       = $cc->addContact( ACCESS_TOKEN, $contact );
			echo '<span class="success-message">Thank you for signing up for the Animal Necessity newsletter!</span>';
			// update the existing contact if address already existed
		} else {
			$action = "Updating Contact";

			$contact = $response->results[0];
			$contact->addList( $_POST['cc-list'] );
			$contact->first_name = $_POST['cc-name'];
			$returnContact       = $cc->updateContact( ACCESS_TOKEN, $contact );
			echo '<span class="success-message">Thank you for signing up for the Animal Necessity newsletter!</span>';

		}

		// catch any exceptions thrown during the process and print the errors to screen
	}
	catch ( CtctException $ex ) {
		echo '<span class="label label-important">Error ' . $action . '</span>';
		echo '<div class="container alert-error"><pre class="failure-pre">';
		print_r( $ex->getErrors() );
		echo '</pre></div>';
		die();
	}
}

?>
<form role="form" action="#newsletter" id="cc-form" class="cta-form" method="post" >
	<span class="no-spam"></span>
	<div class="form-group">
		<input type="hidden" name="cc-list" value="41"><!-- Pet owner list -->
		<input id="f-name" name="cc-name" class="form-control" type="text" placeholder="First Name" data-bv-notempty="true" tabindex="1">
		<input type="email" name="cc-email" class="form-control" required id="e-mail" placeholder="E-Mail" tabindex="3">
		<input type="submit" class="submit-btn" tabindex="5" value="Join Now!" />
	</div>
</form>