<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package ocuglo
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<link rel="icon" type="image/png" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/favicon.png">
	<?php wp_head(); ?>
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=UA-11036731-1"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());

	  gtag('config', 'UA-11036731-1');
	</script>
	
	<!-- Meta Pixel Code -->
	<script>
	!function(f,b,e,v,n,t,s)
	{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
	n.callMethod.apply(n,arguments):n.queue.push(arguments)};
	if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
	n.queue=[];t=b.createElement(e);t.async=!0;
	t.src=v;s=b.getElementsByTagName(e)[0];
	s.parentNode.insertBefore(t,s)}(window, document,'script',
	'https://connect.facebook.net/en_US/fbevents.js');
	fbq('init', '2818842461699454');
	fbq('track', 'PageView');
	</script>
	<noscript><img height="1" width="1" style="display:none"
	src="https://www.facebook.com/tr?id=2818842461699454&ev=PageView&noscript=1"
	/></noscript>
	<!-- End Meta Pixel Code --> 
	
</head>

<body <?php body_class(); ?>>


<div id="fb-root"></div>
<script>(function ( d, s, id ) {
		var js, fjs = d.getElementsByTagName( s )[0];
		if ( d.getElementById( id ) ) return;
		js = d.createElement( s );
		js.id = id;
		js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.3&appId=220596284639969";
		fjs.parentNode.insertBefore( js, fjs );
	}( document, 'script', 'facebook-jssdk' ));</script>
<div id="page" class="hfeed site">
	<header id="masthead" class="site-header" role="banner">
    
    
<!--<div style="background:#600;color:#fff;padding:10px;margin:-10px 0 10px 0;">Due to significant increases in order volume within our shipping warehouse, we have been experiencing some delays in getting shipments out within the normal 24 hour time frame. We, along with our warehouse employees, are working diligently to stay current and get orders out in a timely manner. This is our primary focus and we are taking every measure possible to service our clients. We appreciate your support and patience during this time.</div>-->


		<div class="container">
			<div class="site-branding">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/ocu-glo-logo.png" title="Ocu-GLO - Vision Supplement" /></a>
			</div>
			<!-- .site-branding -->

			<div class="header-secondary">
				<ul class="header-secondary-nav">
					<li><a href="<?php echo get_permalink( 16 ); ?>" title="" class="contact-us">Contact Us</a></li>
					<li><a href="tel:18007211310" title="Click to Call Ocu-GLO" class="tel-phone">1-800-721-1310</a>
					</li>
				</ul>
			</div>

			<nav id="site-navigation" class="main-navigation" role="navigation">
				<button id="menu-toggle" class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php _e( 'Primary Menu', 'ocuglo' ); ?></button>
				<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>
			</nav>
			<!-- #site-navigation -->
		</div>
	</header>
	<!-- #masthead -->

	<div id="content" class="site-content">
