<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package ocuglo
 */
?>

</div><!-- #content -->

<?php
//Home skinny footer
if ( is_home() || is_front_page() ) { ?>
	<footer id="homepage-footer" class="site-footer" role="contentinfo">
		<div class="container">
			<?php wp_nav_menu( array( 'nav' => 'Homepage Footer', 'menu_id' => 'homepage-footer-menu' ) ); ?>
			<?php get_template_part( 'inc/social-media' ); ?>
			<p class="copy">&copy; Copyright <?php date( 'Y' ); ?> &middot; All Rights Reserved &middot;
				<a href="/privacy-policy">Privacy Policy</a> &middot; <a href="/terms-of-use">Terms of Use</a></p>
		</div>
	</footer><!-- #colophon -->
<?php } else { ?>
	<!--newsletter goes here-->
	<footer id="interior-footer" class="site-footer" role="contentinfo">

		<div class="container clearfix">
			<div class="nav-wrap-left">
				<?php wp_nav_menu( array( 'nav' => 'Footer', 'menu_id' => 'primary-menu' ) ); ?>
				<?php get_template_part( 'inc/social-media' ); ?>
				<p class="copy">&copy; Copyright <?php date( 'Y' ); ?> &middot; All Rights Reserved &middot;
					<a href="/privacy-policy">Privacy Policy</a> &middot; <a href="/terms-of-use">Terms of Use</a></p>
			</div>

			<div class="footer-right clearfix">
				<div class="footer-right-top">
					<a href="<?php echo get_bloginfo('url'); ?>"><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/ocuglo-logo-footer.png" alt="Ocu-GLO" /></a>
				</div>
				<div class="footer-right-bottom">
					<p class="phone-contact"><a href="<?php echo get_permalink(16); ?>">Contact Us</a> or Call: <?php echo get_field('phone_number', 'option'); ?></p>
				</div>
			</div>

		</div>

	</footer><!-- #colophon -->
<?php } ?>


</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
